

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||      Easy Render Script	      |||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||    Jonathan Davies - 2004       |||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||    mail@jonathandavies.co.uk    |||||||||||||"
logmessage "||||||||| http://www.jonathandavies.co.uk |||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||                                 |||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||||"

' To run this script type: xsibatch -r -script "easy_render.vbs"

' The idea of this script is to be able to batch render exactly what you need.
' Especially useful when you have odd frames to render from different passes.

' To set up this script just use a text editor with good find and replace facilities
' to rename the passes to those in your scene.
'
' As this is a .vbs script it can perform any XSI operation before or after rendering,
' most importantly the rendered camera can be changed - something that is not possible
' using the XSI batch renderer normally.

' Once a single camera is setup - the code for each camera can be duplicated to render
' from any other camera. Any other options can be added - e.g rendering different resolutions
' of the same scene.

' To render certain passes - just uncomment (remove the 's) from the 'RenderPass' commands



dim basePath, stepValue


OpenScene "F:\Softimage\my_scene_to_render.scn"		' Scene File to Open
basePath = "f:\renders\myProject"			' Render Path
stepValue = 1						' The Frame count step value





'===================================== Camera 01 ==========================================
'===========================================================================================

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||--- CAMERA 01 -----------------|||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"

setFrameRanges(485, 639)
setStep
setFileName("camera_01")
setCamera("Cameras.camera_01")

'RenderPass "Passes.background"
'RenderPass "Passes.foreground"
'RenderPass "Passes.ashtray"
'RenderPass "Passes.teapot"
'RenderPass "Passes.volumic"
'RenderPass "Passes.ambient_occ"
'RenderPass "Passes.table_reflection"

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "                                                     "




'===================================== Camera 02 ==========================================
'===========================================================================================

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||--- CAMERA 02 -----------------|||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"

SetValue "Passes.background.RenderOptions.StartFrame",			694
SetValue "Passes.foreground.RenderOptions.StartFrame",			694
SetValue "Passes.ashtray.RenderOptions.StartFrame",			694
SetValue "Passes.teapot.RenderOptions.StartFrame",			694
SetValue "Passes.volumic.RenderOptions.StartFrame",			694
SetValue "Passes.ambient_occ.RenderOptions.StartFrame",			694
SetValue "Passes.table_reflection.RenderOptions.StartFrame",		694

SetValue "Passes.background.RenderOptions.EndFrame",			694
SetValue "Passes.foreground.RenderOptions.EndFrame",			770
SetValue "Passes.ashtray.RenderOptions.EndFrame",			694
SetValue "Passes.teapot.RenderOptions.EndFrame",			770
SetValue "Passes.volumic.RenderOptions.EndFrame",			770
SetValue "Passes.ambient_occ.RenderOptions.EndFrame",			770
SetValue "Passes.table_reflection.RenderOptions.EndFrame",		694

setStep
setFileName("camera_02")
setCamera("Cameras.camera_02")

'RenderPass "Passes.background"
'RenderPass "Passes.foreground"
'RenderPass "Passes.ashtray"
'RenderPass "Passes.teapot"
'RenderPass "Passes.volumic"
'RenderPass "Passes.ambient_occ"
'RenderPass "Passes.table_reflection"

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "                                                     "


'===================================== Camera 03 ==========================================
'===========================================================================================

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||--- Camera 03 -----------------|||||||||||||"
logmessage "|||||||||                               |||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"

setFrameRanges(389, 481)
setStep
setFileName("camera_03")
setCamera("Cameras.cam_03")

'RenderPass "Passes.background"
'RenderPass "Passes.foreground"
'RenderPass "Passes.ashtray"
'RenderPass "Passes.teapot"
'RenderPass "Passes.volumic"
'RenderPass "Passes.ambient_occ"
'RenderPass "Passes.table_reflection"

logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
logmessage "                                                     "








endMessage		' Display end message to alert you that the rendering has finished




' Subroutines

sub setFrameRanges(fr_start, fr_end)
	SetValue "Passes.background.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.foreground.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.ashtray.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.teapot.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.volumic.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.ambient_occ.RenderOptions.StartFrame",			fr_start
	SetValue "Passes.table_reflection.RenderOptions.StartFrame",		fr_start

	SetValue "Passes.background.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.foreground.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.ashtray.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.teapot.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.volumic.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.ambient_occ.RenderOptions.EndFrame",			fr_end
	SetValue "Passes.table_reflection.RenderOptions.EndFrame",		fr_end
end sub

sub setCamera(camName)
	SetValue "Passes.background.RenderOptions.PassCamera", camName
	SetValue "Passes.foreground.RenderOptions.PassCamera", camName
	SetValue "Passes.ashtray.RenderOptions.PassCamera", camName
	SetValue "Passes.teapot.RenderOptions.PassCamera", camName
	SetValue "Passes.volumic.RenderOptions.PassCamera", camName
	SetValue "Passes.ambient_occ.RenderOptions.PassCamera", camName
	SetValue "Passes.table_reflection.RenderOptions.PassCamera", camName
end sub

sub setFileName(fileName)	
	SetValue "Passes.background.RenderOptions.ImageFileName", basePath & fileName & "_background.####.ct"
	SetValue "Passes.foreground.RenderOptions.ImageFileName", basePath & fileName & "_foreground.####.ct"
	SetValue "Passes.ashtray.RenderOptions.ImageFileName", basePath & fileName & "_ashtray.####.ct"
	SetValue "Passes.teapot.RenderOptions.ImageFileName", basePath & fileName & "_teapot.####.ct"
	SetValue "Passes.volumic.RenderOptions.ImageFileName", basePath & fileName & "_volumic.####.ct"
	SetValue "Passes.ambient_occ.RenderOptions.ImageFileName", basePath & fileName & "_ambient_occ.####.pic"
	SetValue "Passes.table_reflection.RenderOptions.ImageFileName", basePath & fileName & "_table_reflection.####.ct"
end sub

sub setStep
	SetValue "Passes.background.RenderOptions.Step", stepValue
	SetValue "Passes.foreground.RenderOptions.Step", stepValue
	SetValue "Passes.ashtray.RenderOptions.Step", stepValue
	SetValue "Passes.teapot.RenderOptions.Step", stepValue
	SetValue "Passes.volumic.RenderOptions.Step", stepValue
	SetValue "Passes.ambient_occ.RenderOptions.Step", stepValue
	SetValue "Passes.table_reflection.RenderOptions.Step", stepValue
end sub

sub endMessage
	logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
	logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
	logmessage "|||||||||                               |||||||||||||"
	logmessage "|||||||||                               |||||||||||||"
	logmessage "||||||||| Rendering Finished            |||||||||||||"
	logmessage "|||||||||                               |||||||||||||"
	logmessage "||||||||| If you need to use this       |||||||||||||"
	logmessage "||||||||| computer then please          |||||||||||||"
	logmessage "||||||||| log me off.                   |||||||||||||"
	logmessage "|||||||||                               |||||||||||||"
	logmessage "|||||||||                               |||||||||||||"
	logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
	logmessage "|||||||||||||||||||||||||||||||||||||||||||||||||||||"
end sub