' ------------------------------------------------------------------------------
'
' Lightgen Importer v.0.98

' This script will import text files created by lightgen
' I have included the option to use colors based on intensity values
' The script will also create a custom parameter set located under your rig that
' will allow you to control sky and ground intensity values globally
' Robert Ryan, 28.Sep.2002
' robert@ztox.com
'
' ------------------------------------------------------------------------------
'
' Modified by Jonathan Davies - 27/04/2004
' hdri@jonathandavies.co.uk
' http://www.jonathandavies.co.uk
'
' I Made a few simple tweaks to provide quicker light adjustments:
' 	* New Custom Parameter Set Options (Shadows, Area Lights, Specular, Cone/Spread Angle etc)
' 	* Multiplier for intensity rather than addition - preserves intensity ratios between lights
'	* Added upper and lower sky lights with custom split angle and seperate linked properties
'
'		The Sky light angle is the angle between the lights direction vector and the ground.
'		Any light above this angle is put into the upper light group and any light below the angle
'		but above the ground is added to the lower light group.
'		This allows seperate shadow / lighting control for high and low angle lights - avoiding the
'		problem with low angle bounce lights casting long shadows. Set this value to 0 to group all
'		lights above ground together.
' 	
'	* Added the ability to create reference cubes to show the colour of the lights.
'	  This allows the user to quickly and visually rotate the lighting to match the environment.
'
'     Note: The OpenGL preview may not be able to display all the lights correctly. The render will
'	usually appear brighter than the OpenGL preview with a large number of lights.
'	
' ------------------------------------------------------------------------------


lightgen_import


'//Open file dialog box
sub lightgen_import
	'open the File Browser
	Set oFileBrowser = XSIUIToolkit.FileBrowser
	oFileBrowser.DialogTitle = "Select a Lightgen file"
	
	' Set this path to the location of your lightgen text files to speed up searching
	oFileBrowser.InitialDirectory = "F:\Pictures\camera\school_hdr"
	oFileBrowser.FileBaseName = ".txt"
	oFileBrowser.Filter = "Textfile (*.txt)|*.txt|All Files (*.*)|*.*||"
	
	' Show an open file dialog
	oFileBrowser.ShowOpen					
	
	' If the user selected a file...
	If oFileBrowser.FilePathName <> "" Then
		filename = oFileBrowser.FilePathName
	else
		exit sub
	end If
	
  if parse_file(filename) = False then
    logmessage "Bad file or end of file : "&filename, 2
    exit sub
  end if
  
  logmessage "Done ----------"
  
end sub


function parse_file(fname)
	'//Set scene root
	set mySceneRoot = EnumElements("Project", TRUE)
	set mySceneRoot = SIFilter(mySceneRoot, "Scene", TRUE )(0)
	set mySceneRoot = EnumElements( mySceneRoot , TRUE)
	set mySceneRoot = SIFilter(mySceneRoot, "SceneObject", TRUE)(0)    
    
	'//Open file for reading  
	Const ForReading = 1, ForWriting = 2, ForAppending = 3
	Const TristateUseDefault = -2, TristateTrue = -1, TristateFalse = 0
	Dim fs, f, ts, s
	'ParentObj "B:"&myName, "Cube_" & num
	Set fs = CreateObject("Scripting.FileSystemObject")
	set ts = fs.OpenTextFile(fname, ForReading)
	
	s="!"
    
	set lightgen = AddProp ("Custom_parameter_list",mySceneRoot, , "Lightgen XSI 0.98").Value("Value")
	
	'//Adding the Parameters in the Custom parameter
	SIAddCustomParameter lightgen, "RigName", siString, 0, 0, 0, 0, 0, 0.000, 0.000
	SIAddCustomParameter lightgen, "Offset", siInt4, 8, 1, 10000, , 0, 0, 200
	SIAddCustomParameter lightgen, "Use_colors", siBool, 1.000, 0.000, 1.000, , 0, 0.000, 1.000
	SIAddCustomParameter lightgen, "Create_layer", siBool, 0.000, 0.000, 1.000, , 0, 0.000, 1.000
	SIAddCustomParameter lightgen, "Create_coloured_cubes", siBool, 1.000, 0.000, 1.000, , 0, 0.000, 1.000
	SIAddCustomParameter lightgen, "Main_light_angle", siDouble, 35.000, 0.000, 90.000, , 0, 0.000, 90.000
	
	'//Preset the object name
	setValue lightgen & ".Rigname", "Lightgen"
	setValue lightgen & ".Offset", 100
	
	'//Opening the CustomParameter for the user to Interact with it
	InspectObj mySceneRoot & "." & lightgen,,"Create Lightgen Rig",4
	
	myName = GetValue(lightgen &".RigName")
	mycolor	= GetValue(lightgen &".Use_colors")
	Mylayer = GetValue(lightgen &".Create_layer")
	Myoffset = GetValue(lightgen &".Offset")
	myLightAngle = GetValue(lightgen &".Main_light_angle")
	myCubes = GetValue(lightgen &".Create_coloured_cubes")
    
	DeleteObj mySceneRoot & "." & lightgen
    
	Dim R,G,B
	Dim num
	num = 0
	
	if Mylayer = true then
		CreateLayer , myName, , layerSetCurrentLayer
	end if
	
	DeselectAll
	CreateModel
	SetValue "Model.Name", myName

		'// Create Custom Parameter Set
		SelectObj myName
		AddProp "Custom_parameter_list", , , "Lightgen_control"
		
		' ----- Upper Sky Parameters -----
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyShadowsEnable", siBool, 1.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyAreaLightsEnable", siBool, 1.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkySpecular", siBool, 1.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyIntensity", siDouble, 1.000, 0.000, 100.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyShadowUmbra", siDouble, 0.200, 0.000, 1.000, , 5, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyAreaLightsSamples", siInt4, 4.000, 0.000, 20.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyAreaLightsSize", siDouble, 3.000, 0.000, 50.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkyConeAngle", siDouble, 120.000, 0.000, 180.000, , 5, 0.000, 180.000
		SIAddCustomParameter myName & ".Lightgen_control", "upperSkySpreadAngle", siDouble, 40.000, 0.000, 180.000, , 5, 0.000, 180.000
		
		' ----- Lower Sky Parameters -----
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyShadowsEnable", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyAreaLightsEnable", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkySpecular", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyIntensity", siDouble, 1.000, 0.000, 100.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyShadowUmbra", siDouble, 0.500, 0.000, 1.000, , 5, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyAreaLightsSamples", siInt4, 4.000, 0.000, 20.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyAreaLightsSize", siDouble, 3.000, 0.000, 50.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkyConeAngle", siDouble, 120.000, 0.000, 180.000, , 5, 0.000, 180.000
		SIAddCustomParameter myName & ".Lightgen_control", "lowerSkySpreadAngle", siDouble, 20.000, 0.000, 180.000, , 5, 0.000, 180.000
		
		' ----- Ground Parameters -----
		SIAddCustomParameter myName & ".Lightgen_control", "GroundShadowsEnable", siBool, 0.000, 0.000, 1.000, , 0, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundAreaLightsEnable", siBool, 0.000, 0.000, 1.000, , 0, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundSpecular", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundIntensity", siDouble, 1.000, 0.000, 100.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundShadowUmbra", siDouble, 0.500, 0.000, 1.000, , 5, 0.000, 1.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundAreaLightsSamples", siInt4, 4.000, 0.000, 20.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundAreaLightsSize", siDouble, 3.000, 0.000, 50.000, , 5, 0.000, 10.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundConeAngle", siDouble, 120.000, 0.000, 180.000, , 5, 0.000, 180.000
		SIAddCustomParameter myName & ".Lightgen_control", "GroundSpreadAngle", siDouble, 20.000, 0.000, 180.000, , 5, 0.000, 180.000
    		
    		' ------ Cube Marker Parameter Set ----------
    	SelectObj myName
    	AddProp "Custom_parameter_list", , , "Cube_Marker_Control"
    	SIAddCustomParameter myName & ".Cube_Marker_Control", "RenderVisibility", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
    	SIAddCustomParameter myName & ".Cube_Marker_Control", "ViewportVisibility", siBool, 1.000, 0.000, 1.000, , 1, 0.000, 1.000
    	SIAddCustomParameter myName & ".Cube_Marker_Control", "Shadows", siBool, 0.000, 0.000, 1.000, , 1, 0.000, 1.000
	SIAddCustomParameter myName & ".Cube_Marker_Control", "CubeSize", siDouble, 2.500, 0.000, 100.000, , 5, 0.000, 20.000

    		
    		

   do while (ts.AtEndOfStream = false)

	if inStr(s, "Color") then
		
		'//Get color information
		Color = split(s)
		red = Color(2)
		green = Color(3)
		blue = Color(4)
		
		s = ts.ReadLine
		
		'//Get position information
   	
		Pos = split(s)
		
		'//Create model
 		GetPrimLight "Spot.Preset", "Spot_" & num
		ParentObj "B:"&myName, "Spot_"&num&"_Root"
		
		
		
		if (red > green) then
			intens = red
		else
			intens = green
		end if
		
		if (intens > blue) then
			mx = intens
		else
			mx = blue
		end if		
		
		'MsgBox mx & " " & len(s)
	
		intens = mx
		red = red / mx
		green = green / mx
		blue = blue / mx
	
		if mycolor = true then
			SetValue Myname &".Spot_"&num&".light.soft_light.color.red", red
			SetValue Myname &".Spot_"&num&".light.soft_light.color.green", green
			SetValue Myname &".Spot_"&num&".light.soft_light.color.blue", blue
		end if
	
		SetValue Myname &".Spot_"&num&".light.soft_light.intensity", intens * 2
		SetValue Myname &".Spot_"&num&".light.LightAreaGeom", 2
		
		Translate , -Myoffset*Pos(1), -Myoffset*Pos(2), -Myoffset*Pos(3) , siAbsolute, siGlobal, siObj, siXYZ
   		ApplyCns "Position", Myname &".Spot_" &num& "_Interest", myName
   		
   		if myCubes = true then
			CreatePrim "Cube", "MeshSurface", "Cube_" & num
			Translate , -Myoffset*Pos(1), -Myoffset*Pos(2), -Myoffset*Pos(3) , siAbsolute, siGlobal, siObj, siXYZ
			
			' Set Cube Properties
			'SetValue ".cube.length", 2
			ApplyShader "Material\Constant", , , , siLetLocalMaterialsOverlap
			SetValue ".Material.Constant.color.red", red
			SetValue ".Material.Constant.color.green", green
			SetValue ".Material.Constant.color.blue", blue
			'SetValue ".visibility.shdw", False
			'SetValue ".visibility.rendvis", False
			ParentObj myName & ".Spot_" & num & "_Root", "Cube_" & num
			
			'Set Control Expressions
			SetExpr myName & ".Cube_" & num & ".visibility.rendvis", myName & ".Cube_Marker_Control.RenderVisibility"
			SetExpr myName & ".Cube_" & num & ".visibility.shdw", myName & ".Cube_Marker_Control.Shadows"
			SetExpr myName & ".Cube_" & num & ".visibility.viewvis", myName & ".Cube_Marker_Control.ViewportVisibility"
			SetExpr myName & ".Cube_" & num & ".cube.length", myName & ".Cube_Marker_Control.CubeSize"
		end if
   		
		'logmessage "pos2 = " & Pos(2)
		dim v1, v2, aR, aD
		set v1 = XSIMath.createVector3
		set v2 = XSIMath.createVector3
		v1.Set Pos(1), 0.0, Pos(3)
		v2.Set Pos(1), Pos(2), Pos(3)
		aR = v1.angle(v2)
		aD = XSIMath.radiansToDegrees(aR)
		'logmessage aD
	
		if Pos(2) < 0 then
			if aD > myLightAngle then
				SetExpr myName & ".Spot_" & num & ".light.soft_light.intensity", myName & ".Lightgen_control.upperSkyIntensity * " &intens
				SetExpr myName & ".Spot_" & num & ".light.soft_light.shadow", myName & ".Lightgen_control.upperSkyShadowsEnable"
				SetExpr myName & ".Spot_" & num & ".light.soft_light.factor", myName & ".Lightgen_control.upperSkyShadowUmbra"
				SetExpr myName & ".Spot_" & num & ".light.LightCone", myName & ".Lightgen_control.upperSkyConeAngle"
				SetExpr myName & ".Spot_" & num & ".light.soft_light.spread", myName & ".Lightgen_control.upperSkySpreadAngle"
				SetExpr myName & ".Spot_" & num & ".light.SpecularContribution", myName & ".Lightgen_control.upperSkySpecular"
				SetExpr myName & ".Spot_" & num & ".light.LightArea", myName & ".Lightgen_control.upperSkyAreaLightsEnable"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSX", myName & ".Lightgen_control.upperSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSY", myName & ".Lightgen_control.upperSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSZ", myName & ".Lightgen_control.upperSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaSampU", myName & ".Lightgen_control.upperSkyAreaLightsSamples"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaSampV", myName & ".Lightgen_control.upperSkyAreaLightsSamples"
			else
				SetExpr myName & ".Spot_" & num & ".light.soft_light.intensity", myName & ".Lightgen_control.lowerSkyIntensity * " &intens
				SetExpr myName & ".Spot_" & num & ".light.soft_light.shadow", myName & ".Lightgen_control.lowerSkyShadowsEnable"
				SetExpr myName & ".Spot_" & num & ".light.soft_light.factor", myName & ".Lightgen_control.lowerSkyShadowUmbra"
				SetExpr myName & ".Spot_" & num & ".light.LightCone", myName & ".Lightgen_control.lowerSkyConeAngle"
				SetExpr myName & ".Spot_" & num & ".light.soft_light.spread", myName & ".Lightgen_control.lowerSkySpreadAngle"
				SetExpr myName & ".Spot_" & num & ".light.SpecularContribution", myName & ".Lightgen_control.lowerSkySpecular"
				SetExpr myName & ".Spot_" & num & ".light.LightArea", myName & ".Lightgen_control.lowerSkyAreaLightsEnable"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSX", myName & ".Lightgen_control.lowerSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSY", myName & ".Lightgen_control.lowerSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSZ", myName & ".Lightgen_control.lowerSkyAreaLightsSize"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaSampU", myName & ".Lightgen_control.lowerSkyAreaLightsSamples"
				SetExpr myName & ".Spot_" & num & ".light.LightAreaSampV", myName & ".Lightgen_control.lowerSkyAreaLightsSamples"
			end if
		else
			SetExpr myName & ".Spot_" & num & ".light.soft_light.intensity",myName & ".Lightgen_control.GroundIntensity * " &intens
			SetExpr myName & ".Spot_" & num & ".light.soft_light.shadow", myName & ".Lightgen_control.GroundShadowsEnable"
			SetExpr myName & ".Spot_" & num & ".light.soft_light.factor", myName & ".Lightgen_control.GroundShadowUmbra"
			SetExpr myName & ".Spot_" & num & ".light.LightCone", myName & ".Lightgen_control.GroundConeAngle"
			SetExpr myName & ".Spot_" & num & ".light.soft_light.spread", myName & ".Lightgen_control.GroundSpreadAngle"
			SetExpr myName & ".Spot_" & num & ".light.SpecularContribution", myName & ".Lightgen_control.GroundSpecular"
			SetExpr myName & ".Spot_" & num & ".light.LightArea", myName & ".Lightgen_control.GroundAreaLightsEnable"
			SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSX", myName & ".Lightgen_control.GroundAreaLightsSize"
			SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSY", myName & ".Lightgen_control.GroundAreaLightsSize"
			SetExpr myName & ".Spot_" & num & ".light.LightAreaXformSZ", myName & ".Lightgen_control.GroundAreaLightsSize"
			SetExpr myName & ".Spot_" & num & ".light.LightAreaSampU", myName & ".Lightgen_control.GroundAreaLightsSamples"
			SetExpr myName & ".Spot_" & num & ".light.LightAreaSampV", myName & ".Lightgen_control.GroundAreaLightsSamples"
		end if
	   
		num = num + 1
	else
		s = ts.ReadLine
	end if
   loop

ts.Close
end function


